<%@ Control Language="c#" AutoEventWireup="false" Codebehind="ProjectTime.ascx.cs" Inherits="Mediachase.UI.Web.UserReports.Modules.ProjectTime" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<table cellpadding="0" cellspacing="10">
	<tr>
		<td class="text"><%=LocRM.GetString("Project")%>:</td>
		<td>
			<asp:DropDownList Runat="server" ID="ddlProject" DataTextField="Title" DataValueField="ProjectId"></asp:DropDownList>
		</td>
	</tr>
	<tr Printable="0">
		<td></td>
		<td>
			<asp:button id="btnSubmit" CssClass="text" Width="80" Runat="server" Text="Show!"></asp:button>
		</td>
	</tr>
</table>
<asp:repeater id="rptMain" Runat="server" EnableViewState="false">
	<HeaderTemplate>
		<table class="text" border="0" cellspacing="0" cellpadding="1" width="100%">
			<colgroup>
				<col>
				<col>
				<col align="center">
				<col align="center">
				<col align="center">
			</colgroup>
			<tr class="ibn-vh2">
				<td><%=LocRM.GetString("Title")%></td>
				<td><%=LocRM.GetString("Type")%></td>
				<td><%=LocRM.GetString("Plan")%></td>
				<td><%=LocRM.GetString("Fact")%></td>
				<td><%=LocRM.GetString("Approved")%></td>
			</tr>
	</HeaderTemplate>
	<ItemTemplate>
		<tr>
			<td class="ibn-vb2"><%# DataBinder.Eval(Container.DataItem,"Title")%></td>
			<td class="ibn-vb2"><%# LocRM.GetString("ObjectType_" + DataBinder.Eval(Container.DataItem,"ObjectTypeId").ToString())%></td>
			<td class="ibn-vb2"><%# GetHours((int)DataBinder.Eval(Container.DataItem,"TaskTime"))%></td>
			<td class="ibn-vb2"><%# GetHours((int)DataBinder.Eval(Container.DataItem,"Total"))%></td>
			<td class="ibn-vb2"><%# GetHours((int)DataBinder.Eval(Container.DataItem,"TotalApproved"))%></td>
		</tr>
	</ItemTemplate>
	<AlternatingItemTemplate>
		<tr class="ibn-alternating">
			<td class="ibn-vb2"><%# DataBinder.Eval(Container.DataItem,"Title")%></td>
			<td class="ibn-vb2"><%# LocRM.GetString("ObjectType_" + DataBinder.Eval(Container.DataItem,"ObjectTypeId").ToString())%></td>
			<td class="ibn-vb2"><%# GetHours((int)DataBinder.Eval(Container.DataItem,"TaskTime"))%></td>
			<td class="ibn-vb2"><%# GetHours((int)DataBinder.Eval(Container.DataItem,"Total"))%></td>
			<td class="ibn-vb2"><%# GetHours((int)DataBinder.Eval(Container.DataItem,"TotalApproved"))%></td>
		</tr>
	</AlternatingItemTemplate>
	<FooterTemplate>
		<tr style="font-weight:bold">
			<td class="ibn-vb2"><%=LocRM.GetString("Total")%>:</td>
			<td class="ibn-vb2">&nbsp;</td>
			<td class="ibn-vb2"><%=GetHours(TotalPlan)%></td>
			<td class="ibn-vb2"><%=GetHours(TotalFact)%></td>
			<td class="ibn-vb2"><%=GetHours(TotalApproved)%></td>
		</tr>
	</table>
	</FooterTemplate>
</asp:repeater>
